using inetsoftware.Pdfc;
using inetsoftware.Pdfc.Presenter;
using System;

namespace inetsoftware.PdfcSamples
{
    /// <summary>
    /// A sample for logger output.
    /// This sample uses the simplest logger: it logs to the console log stream.
    /// </summary>
    class SimpleConsole
    {
        static SimpleConsole()
        {
            // Activate the license once from environment if required.
            string key = Environment.GetEnvironmentVariable("PDFC_KEY");
            if (!string.IsNullOrEmpty(key))
            {
                PDFC.ActivateLicense(key);
            }
        }

        /// <summary>
        /// Start the sample, that uses the simplest logger: it logs to the console log stream.
        /// </summary>
        /// <param name="args">Expected 2 arguments, the path of the PDF files.</param>
        public static void Main(string[] args)
        {
            if (args == null || args.Length != 2)
            {
                throw new ArgumentException("Usage: <executable> <PDF-File1> <PDF-File2>");
            }

            // This line is NOT required but a hint on how to redirect the logging output of the comparison
            inetsoftware.ProcessBridge.ProcessConfig.ProcessConsole = System.Console.Out; // Console is default, can be redirected to a file here

            using (
                new PDFComparer() // create a comparer instance
                .AddPresenter(new ConsolePresenter()) // add an output format, which is console in this case
                .Compare(args[0], args[1])) // run the comparison for the two files passed as arguments
            { }
        }

    }
}
